<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:ucles="http://www.ucles.org.uk" exclude-result-prefixes="fo">
    <xsl:output method="xml" version="1.0" omit-xml-declaration="no" indent="yes"/>

    <xsl:template match="/">
        <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
            <fo:layout-master-set>
                <fo:simple-page-master master-name="simpleA4" page-height="29.7cm" page-width="21cm" margin-top="1.5cm" margin-bottom="2cm" margin-left="2cm" margin-right="2cm">
                    <fo:region-body/>
                </fo:simple-page-master>
            </fo:layout-master-set>

            <fo:page-sequence master-reference="simpleA4">
                <fo:flow flow-name="xsl-region-body">
			        <xsl:apply-templates select="centre"/>
				</fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>

    <xsl:template match="centre">
		<fo:block space-after="7mm">
			<fo:external-graphic src="url('storage/component-bundles/pdf/pdf_header.gif')"/>
		</fo:block>
		<fo:block>
			<fo:inline font-size="18pt" font-weight="bold">ATTENDANCE REGISTER - ESOL </fo:inline><xsl:value-of select="available-sessions/name"/>
		</fo:block>

		<fo:block space-before="3mm">
			<fo:table table-layout="fixed">
				<fo:table-column column-width="9cm"/>
				<fo:table-column column-width="4cm"/>
				<fo:table-column column-width="4cm"/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell padding="1mm" border-width="1px"  border-style="solid" border-color="black">
							<fo:block font-weight="bold" font-size="12pt">
								PAPER NAME
							</fo:block>
						</fo:table-cell>
						<fo:table-cell padding="1mm" border-width="1px"  border-style="solid" border-color="black">
							<fo:block font-weight="bold" font-size="12pt">
								PAPER NUMBER
							</fo:block>
						</fo:table-cell>
						<fo:table-cell padding="1mm" border-width="1px"  border-style="solid" border-color="black">
							<fo:block font-weight="bold" font-size="12pt">
								DATE
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
					<fo:table-row>
						<fo:table-cell padding="1mm" border-width="1px"  border-style="solid" border-color="black">
							<fo:block font-size="12pt">
								<xsl:value-of select="available-sessions/component-list/name"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell padding="1mm" border-width="1px"  border-style="solid" border-color="black">
							<fo:block font-size="12pt">
								<xsl:value-of select="concat(available-sessions/assessment-code, '/', available-sessions/component-list/id)"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell padding="1mm" border-width="1px"  border-style="solid" border-color="black">
							<fo:block font-size="12pt">
                                <xsl:call-template name="reverseDate">
                                    <xsl:with-param name="date" select="substring-before(uccs-time, 'T')"/>
                                </xsl:call-template>
                                <!-- eg 1970-01-01T01:00:00.000+0100 -->
                                <xsl:value-of select="concat('',' ',concat(substring-before(substring-after(uccs-time, 'T'),':'), ':', substring-before(substring-after(uccs-time, ':'),':')))"/>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
					<fo:table-row>
						<fo:table-cell padding="1mm" number-columns-spanned="2" border-width="1px"  border-style="solid" border-color="black">
							<fo:block font-weight="bold" font-size="12pt">
								CENTRE NAME
							</fo:block>
						</fo:table-cell>
						<fo:table-cell padding="1mm" border-width="1px"  border-style="solid" border-color="black">
							<fo:block font-weight="bold" font-size="12pt">
								CENTRE NUMBER
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
					<fo:table-row border-width="2px">
						<fo:table-cell padding="1mm" number-columns-spanned="2" border-width="1px"  border-style="solid" border-color="black">
							<fo:block font-size="12pt">
								<xsl:value-of select="name"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell padding="1mm" border-width="1px"  border-style="solid" border-color="black">
							<fo:block font-size="12pt">
								<xsl:value-of select="number"/>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
		</fo:block>

		<fo:block font-size="10pt" space-before="10mm">
			<fo:table table-layout="fixed">
				<fo:table-column column-width="3cm"/>
				<fo:table-column column-width="7cm"/>
				<fo:table-column column-width="3.5cm"/>
				<fo:table-column column-width="3.5cm"/>
				<fo:table-body>
					<fo:table-row space-after="50mm">
						<fo:table-cell>
							<fo:block font-weight="bold">
														CAND. No.
							</fo:block>
						</fo:table-cell>
						<fo:table-cell>
							<fo:block font-weight="bold">
														CANDIDATE NAME
							</fo:block>
						</fo:table-cell>
						<fo:table-cell>
							<fo:block font-weight="bold">
														ATTENDANCE
							</fo:block>
						</fo:table-cell>
						<fo:table-cell>
							<fo:block font-weight="bold">
														SEAT
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
					<!-- spacer -->
					<fo:table-row>
						<fo:table-cell number-columns-spanned="4">
							<fo:block space-after="0mm" border-width="0.5pt" border-style="solid" border-color="black">
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
					<xsl:apply-templates select="available-sessions/component-list/component-version-list"/>
				</fo:table-body>
			</fo:table>
		</fo:block>
    </xsl:template>

    <xsl:template match="component-version-list">
        <xsl:apply-templates select="candidates"/>
    </xsl:template>

    <xsl:template match="candidates">
        <fo:table-row>
            <fo:table-cell padding="1mm" display-align="center" border-width="0.5pt" border-style="solid" border-color="rgb(210,210,210)">
                <fo:block>
                    <xsl:value-of select="candidate-number"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell padding="1mm" display-align="center" border-width="0.5pt" border-style="solid" border-color="rgb(210,210,210)">
                <fo:block>
                    <xsl:value-of select="concat(last-name,', ',first-name)"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell padding="1mm" display-align="center" border-width="0.5pt" border-style="solid" border-color="rgb(210,210,210)">
                <fo:block>

                </fo:block>
            </fo:table-cell>
            <fo:table-cell padding="1mm" display-align="center" border-width="0.5pt" border-style="solid" border-color="rgb(210,210,210)">
                <fo:block>

                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    <xsl:template name="reverseDate">
        <xsl:param name="date"/>
        <xsl:choose>
            <xsl:when test="contains($date,'-')">
                <xsl:call-template name="reverseDate">
                    <xsl:with-param name="date" select="substring-after($date,'-')"/>
                </xsl:call-template>
                <xsl:text>/</xsl:text>
                <xsl:value-of select="substring-before($date,'-')"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$date"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="createDateTime">
        <xsl:param name="date"/>
        <xsl:call-template name="createDateTime">
            <xsl:with-param name="date" select="uccs-time"/>
        </xsl:call-template>

    </xsl:template>
</xsl:stylesheet>